/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.snmp.SnmpPDUException;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpUnknownHostException;
import ibm.nways.jdm.topology.EndPoint;
import ibm.nways.jdm.traceroute.CpuUtilization;
import ibm.nways.jdm.traceroute.NetInterface;
import ibm.nways.jdm.traceroute.RemotePing;
import ibm.nways.jdm.traceroute.RemotePingException;
import ibm.nways.jdm.traceroute.RemoteTraceException;
import ibm.nways.jdm.traceroute.RouteTable;
import ibm.nways.jdm.traceroute.Util;
import java.awt.Color;
import java.awt.Panel;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import jclass.util.JCImageCreator;

public class Node
implements Serializable,
EndPoint {
    protected String voyagerAddress;
    protected IPAddress ipAddress;
    protected String dnsName = "";
    protected String systemDescription;
    protected String systemLocation;
    protected String communityName = "public";
    protected transient RouteTable rTable;
    private static final boolean debug = false;
    private static ResourceBundle strings = ResourceBundle.getBundle((class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? class$ibm$nways$jdm$traceroute$TraceRouteResources : (class$ibm$nways$jdm$traceroute$TraceRouteResources = Node.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    protected RemotePing rPing;
    private int snmpLookupStatus;
    public static final int SNMP_LOOKUP_NOT_ATTEMPTED = 1;
    public static final int SNMP_LOOKUP_SUCCESSFUL = 2;
    public static final int SNMP_LOOKUP_FAILED = 3;
    protected String[] pixels = new String[]{"                                        ", "                                        ", "                   BB                   ", "                  BBBB                  ", "                 BBssBB                 ", "                BBssssBB                ", "               BBssssssBB               ", "              BBssssssssBB              ", "             BBssssssssssBB             ", "            BBssssssssssssBB            ", "           BBssssssssssssssBB           ", "          BBssssssssssssssssBB          ", "         BBssssssssssssssssssBB         ", "        BBssssssssssssssssssssBB        ", "       BBssssssssssssssssssssssBB       ", "      BBssssssssssssssssssssssssBB      ", "     BBssssssssssssssssssssssssssBB     ", "    BBssssssssssssssssssssssssssssBB    ", "   BBssssssssssssssssssssssssssssssBB   ", "  BBssssssssssssssssssssssssssssssssBB  ", "  BBssssssssssssssssssssssssssssssssBB  ", "   BBssssssssssssssssssssssssssssssBB   ", "    BBssssssssssssssssssssssssssssBB    ", "     BBssssssssssssssssssssssssssBB     ", "      BBssssssssssssssssssssssssBB      ", "       BBssssssssssssssssssssssBB       ", "        BBssssssssssssssssssssBB        ", "         BBssssssssssssssssssBB         ", "          BBssssssssssssssssBB          ", "           BBssssssssssssssBB           ", "            BBssssssssssssBB            ", "             BBssssssssssBB             ", "              BBssssssssBB              ", "               BBssssssBB               ", "                BBssssBB                ", "                 BBssBB                 ", "                  BBBB                  ", "                   BB                   ", "                                        ", "                                        "};
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteResources;

    public Node(IPAddress iPAddress) {
        this(iPAddress, "public", null);
    }

    public Node(IPAddress iPAddress, String string) {
        this(iPAddress, string, null);
    }

    public Node(IPAddress iPAddress, String string, String string2) {
        this.ipAddress = new IPAddress(iPAddress.toString());
        this.communityName = string;
        this.voyagerAddress = string2;
        this.snmpLookupStatus = 1;
    }

    public String getId() {
        String string = null;
        string = this.dnsName != null && this.dnsName.length() > 0 ? this.dnsName : this.ipAddress.toString();
        return string;
    }

    public synchronized String getDnsName() {
        if (this.dnsName.length() == 0) {
            this.dnsName = Util.dnsLookup(this.ipAddress, this.voyagerAddress);
            if (this.dnsName == null) {
                this.dnsName = strings.getString("Unknown");
            }
        }
        return this.dnsName;
    }

    public synchronized String getShortDnsName() {
        if (this.dnsName.length() == 0) {
            this.getDnsName();
        }
        if (Character.isDigit(this.dnsName.charAt(0))) {
            return this.dnsName;
        }
        int n = this.dnsName.indexOf(46);
        if (n == -1) {
            return this.dnsName;
        }
        return this.dnsName.substring(0, n);
    }

    public IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public String getCommunityName() {
        return this.communityName;
    }

    public int getSnmpLookupStatus() {
        this.getDataFromSnmp();
        return this.snmpLookupStatus;
    }

    public String getSysDescr() {
        return this.getSysDescr(0);
    }

    public String getShortSysDescr() {
        return this.getSysDescr(23);
    }

    public String getSysDescr(int n) {
        this.getDataFromSnmp();
        String string = this.systemDescription == null ? strings.getString("Unavailable") : this.systemDescription;
        return Util.trimString(string, n);
    }

    public String getSysLocation() {
        this.getDataFromSnmp();
        if (this.systemLocation == null) {
            return strings.getString("Unavailable");
        }
        return this.systemLocation;
    }

    public String getNodeStatusString() {
        String string = CpuUtilization.getUtilizationString(this.ipAddress, this.communityName, this.voyagerAddress);
        if (string != null) {
            return string;
        }
        if (this.snmpLookupStatus == 1) {
            this.getDataFromSnmp();
        }
        if (this.snmpLookupStatus == 2) {
            return strings.getString("NodeUp");
        }
        return strings.getString("NodeUnknown");
    }

    public boolean equals(Node node) {
        return this.ipAddress.equals(node.getIPAddress());
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            return this.equals((Node)object);
        }
        return false;
    }

    public Object[] getInterfaceAndNextHop(Node node) throws SnmpUnknownHostException, SnmpSocketException, SnmpPDUException, NoSuchElementException, Exception {
        Object[] objectArray = new Object[2];
        try {
            this.rTable = Util.getRouteTable(this.getIPAddress(), this.communityName, this.voyagerAddress);
            Enumeration enumeration = this.rTable.getEnumeration();
            RouteTable.RouteTableRow routeTableRow = (RouteTable.RouteTableRow)enumeration.nextElement();
            IPAddress iPAddress = node.getIPAddress();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                IPAddress iPAddress2;
                IPAddress iPAddress3;
                RouteTable.RouteTableRow routeTableRow2 = (RouteTable.RouteTableRow)enumeration.nextElement();
                IPAddress iPAddress4 = routeTableRow2.getIpRouteDest();
                IPAddress iPAddress5 = iPAddress4.applyMask(iPAddress3 = routeTableRow2.getIpRouteMask());
                if (!iPAddress5.equals(iPAddress2 = iPAddress.applyMask(iPAddress3))) continue;
                Integer n = routeTableRow2.getIpRouteType();
                if (n != null && n.equals(new Integer(3))) {
                    bl = true;
                    objectArray[0] = new NetInterface(this.getIPAddress(), routeTableRow2.getIpRouteIfIndex(), this.communityName, this.voyagerAddress);
                    objectArray[1] = node;
                    return objectArray;
                }
                if (n == null || !n.equals(new Integer(4))) continue;
                bl = true;
                objectArray[0] = new NetInterface(this.getIPAddress(), routeTableRow2.getIpRouteIfIndex(), this.communityName, this.voyagerAddress);
                objectArray[1] = new Node(routeTableRow2.getIpRouteNextHop(), this.communityName, this.voyagerAddress);
                return objectArray;
            }
            if (!bl) {
                objectArray[0] = new NetInterface(this.getIPAddress(), routeTableRow.getIpRouteIfIndex(), this.communityName, this.voyagerAddress);
                objectArray[1] = new Node(routeTableRow.getIpRouteNextHop(), this.communityName, this.voyagerAddress);
                return objectArray;
            }
        }
        catch (SnmpUnknownHostException snmpUnknownHostException) {
            throw snmpUnknownHostException;
        }
        catch (SnmpSocketException snmpSocketException) {
            throw snmpSocketException;
        }
        catch (SnmpPDUException snmpPDUException) {
            throw snmpPDUException;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw noSuchElementException;
        }
        catch (Exception exception) {
            throw exception;
        }
        return objectArray;
    }

    public Object getImage() {
        JCImageCreator jCImageCreator = new JCImageCreator(new Panel(), 40, 40);
        jCImageCreator.setColor('B', Color.black);
        jCImageCreator.setColor('b', Color.blue);
        jCImageCreator.setColor('c', Color.cyan);
        jCImageCreator.setColor('d', Color.darkGray);
        jCImageCreator.setColor('G', Color.gray);
        jCImageCreator.setColor('g', Color.green);
        jCImageCreator.setColor('l', Color.lightGray);
        jCImageCreator.setColor('m', Color.magenta);
        jCImageCreator.setColor('o', Color.orange);
        jCImageCreator.setColor('p', Color.pink);
        jCImageCreator.setColor('r', Color.red);
        jCImageCreator.setColor('w', Color.white);
        jCImageCreator.setColor('y', Color.yellow);
        switch (this.getSnmpLookupStatus()) {
            case 1: {
                jCImageCreator.setColor('s', Color.blue);
                break;
            }
            case 2: {
                jCImageCreator.setColor('s', Color.green);
                break;
            }
            case 3: {
                jCImageCreator.setColor('s', Color.red);
                break;
            }
        }
        jCImageCreator.setPixels(this.pixels);
        return jCImageCreator.create();
    }

    public Object[][] remoteTrace(Node node) throws RemoteTraceException {
        Object[][] objectArray = new Object[2][2];
        objectArray[0][0] = new IPAddress("192.168.0.1");
        objectArray[1][0] = new IPAddress("192.168.0.2");
        objectArray[0][1] = new Integer(23);
        objectArray[1][1] = new Integer(16);
        return objectArray;
    }

    public boolean supportsRemotePing() {
        this.createRemotePingObject();
        return this.rPing.pingSupported();
    }

    public int remotePing(IPAddress iPAddress) throws RemotePingException {
        this.createRemotePingObject();
        return this.rPing.remotePing(iPAddress);
    }

    protected synchronized void createRemotePingObject() {
        if (this.rPing == null) {
            this.rPing = RemotePing.create(this.ipAddress, this.communityName, this.voyagerAddress);
        }
    }

    protected synchronized void getDataFromSnmp() {
        if (this.snmpLookupStatus != 1) {
            return;
        }
        String[] stringArray = new String[]{"1.3.6.1.2.1.1.1.0", "1.3.6.1.2.1.1.6.0"};
        Object[] objectArray = Util.lookupMibVars(this.ipAddress, this.communityName, stringArray, this.voyagerAddress);
        if (objectArray[0] == null) {
            this.snmpLookupStatus = 3;
            return;
        }
        this.snmpLookupStatus = 2;
        this.systemDescription = ((OctetString)objectArray[0]).toDisplayString();
        this.systemLocation = ((OctetString)objectArray[1]).toDisplayString();
    }

    public String toString() {
        String string = this.ipAddress.toString();
        if (this.dnsName.length() > 0) {
            string = String.valueOf(this.dnsName) + " [" + string + "]";
        }
        return string;
    }

    public void debugDump() {
        this.debugDump(false);
    }

    public void debugDump(boolean bl) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("NODE");
            System.out.println(" IpAddress: " + this.ipAddress);
            System.out.println("   DnsName: " + this.dnsName);
            System.out.println("VoyagerPxy: " + this.voyagerAddress);
            System.out.println("  CommName: " + this.communityName);
            switch (this.snmpLookupStatus) {
                case 1: {
                    System.out.println("SnmpLookup: not attempted");
                    break;
                }
                case 2: {
                    System.out.println("SnmpLookup: successful");
                    break;
                }
                case 3: {
                    System.out.println("SnmpLookup: failed");
                    break;
                }
                default: {
                    System.out.println("SnmpLookup: *unknown setting* look for bugs here");
                }
            }
            System.out.println("  SysDescr: " + this.systemDescription);
            System.out.println("    SysLoc: " + this.systemLocation);
            if (this.rPing == null) {
                System.out.println("RemotePing: object not created");
            } else {
                System.out.println("RemotePing: " + this.rPing.getMibName());
            }
            if (bl) {
                if (this.rTable == null) {
                    System.out.println("RouteTable: not loaded");
                } else {
                    System.out.println("RouteTable:");
                    this.rTable.debugDump();
                }
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

